<?php
/**
 * Plugin Name: Small Image
 * Plugin URI: https://Mak8it.com
 * Description: Automatically convert images to WebP format for better performance
 * Version: 1.0.0
 * Author: Mak8it
 * Author URI: https://Mak8it.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: small-image
 * Domain Path: /languages
 * Requires at least: 5.8
 * Requires PHP: 7.4
 *
 * @package Small_Image
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define plugin constants
define( 'SMALL_IMAGE_VERSION', '1.0.0' );
define( 'SMALL_IMAGE_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'SMALL_IMAGE_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'SMALL_IMAGE_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

/**
 * The code that runs during plugin activation.
 */
function activate_small_image() {
	require_once SMALL_IMAGE_PLUGIN_DIR . 'includes/class-activator.php';
	WP_WebP_Optimizer_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 */
function deactivate_small_image() {
	require_once SMALL_IMAGE_PLUGIN_DIR . 'includes/class-activator.php';
	WP_WebP_Optimizer_Activator::deactivate();
}

register_activation_hook( __FILE__, 'activate_small_image' );
register_deactivation_hook( __FILE__, 'deactivate_small_image' );

/**
 * Autoloader for plugin classes.
 *
 * @param string $class_name The name of the class to load.
 */
function small_image_autoloader( $class_name ) {
	// Only autoload classes from this plugin
	if ( strpos( $class_name, 'WP_WebP_Optimizer_' ) !== 0 ) {
		return;
	}

	// Convert class name to file name
	$class_file = 'class-' . strtolower( str_replace( '_', '-', $class_name ) ) . '.php';
	
	// Check in includes directory
	$includes_path = SMALL_IMAGE_PLUGIN_DIR . 'includes/' . $class_file;
	if ( file_exists( $includes_path ) ) {
		require_once $includes_path;
		return;
	}
}

spl_autoload_register( 'small_image_autoloader' );

/**
 * Begin execution of the plugin.
 */
function run_small_image() {
	// Load required files
	require_once SMALL_IMAGE_PLUGIN_DIR . 'includes/class-converter.php';
	require_once SMALL_IMAGE_PLUGIN_DIR . 'includes/class-settings.php';
	require_once SMALL_IMAGE_PLUGIN_DIR . 'includes/class-bulk-processor.php';
	require_once SMALL_IMAGE_PLUGIN_DIR . 'includes/class-stats.php';
	require_once SMALL_IMAGE_PLUGIN_DIR . 'includes/class-ajax-handler.php';
	require_once SMALL_IMAGE_PLUGIN_DIR . 'includes/class-frontend.php';
	
	// Initialize settings page
	$settings = new WP_WebP_Optimizer_Settings();
	$settings->init();
	
	// Initialize converter
	$converter = new WP_WebP_Optimizer_Converter();
	$converter->init();
	
	// Initialize AJAX handler
	$ajax_handler = new WP_WebP_Optimizer_Ajax_Handler();
	$ajax_handler->init();

	// Initialize frontend handler
	$frontend = new WP_WebP_Optimizer_Frontend();
	$frontend->init();
}

add_action( 'plugins_loaded', 'run_small_image' );

